function mark_circular_domain(File,Settings)

% script to mark the domain for monolayer stress microscopy code
% goto the directory which contains folders: Tractions, and FEM

for k = 1:File.NFiles.Fluorescence,
 
if (strcmpi(Settings.DomDrawn,'yes')) == 1   

   % read tractions to get the number of points along X-axis of traction grid
    tractions = load([File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'traction', '.dat']);
    nXPts = sqrt(size(tractions,1))%sqrt may or may not have to be left out
    BW = imread([File.pathname 'croppeddata','/', 'domain', num2str(k), '.tif']);
    
    
        %convert boundary to logical
        if (strcmpi(Settings.DomImagej,'yes')) == 1   
            
           BW =logical(BW);
        
        end
 
 % reshape the domain map to the traction grid size
 BW01 = reshape(imresize(BW,[nXPts nXPts])*1,nXPts*nXPts,1);

% store the reshaped binary map of domain
save([File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'domain', '.dat'],'BW01','-ASCII');
    

else


im = imread(File.Name(k).CropPC);%read phase image

% make binary map of domain
[BW] = roipoly(im);

% read tractions to get the number of points along X-axis of traction grid
tractions = load([File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'traction', '.dat']);


    nXPts = sqrt(size(tractions,1))
    BW01 = reshape(imresize(BW,[nXPts nXPts])*1,nXPts*nXPts,1);
  

% store the reshaped binary map of domain
save([File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'domain', '.dat'],'BW01','-ASCII');

disp(k);

end
end
end

